/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.ui.wizard.exe;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org2.eclipse.php.internal.debug.core.interpreter.preferences.PHPexeItem;
import org2.eclipse.php.internal.debug.ui.wizard.CompositeFragment;
import org2.eclipse.php.internal.debug.ui.wizard.ICompositeFragmentFactory;
import org2.eclipse.php.internal.debug.ui.wizard.IControlHandler;
import org2.eclipse.php.internal.debug.ui.wizard.WizardFragmentsFactoryRegistry;
import org2.eclipse.php.internal.debug.ui.wizard.exe.IPHPExeCompositeFragment;
import org2.eclipse.php.util.SWTUtil;

public class PHPExeEditDialog
extends TitleAreaDialog
implements IControlHandler {
    protected static final String FRAGMENT_GROUP_ID = "org2.eclipse.php.debug.ui.phpExeWizardCompositeFragment";
    private List<CompositeFragment> runtimeComposites;
    private PHPexeItem phpExeItem;
    private PHPexeItem[] existingItems;
    private final boolean shouldValidate;

    public PHPExeEditDialog(Shell shell, PHPexeItem phpExeItem, PHPexeItem[] existingItems) {
        this(shell, phpExeItem, existingItems, false);
    }

    public PHPExeEditDialog(Shell shell, PHPexeItem phpExeItem, PHPexeItem[] existingItems, boolean shouldValidate) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.existingItems = existingItems;
        this.phpExeItem = phpExeItem;
        this.runtimeComposites = new ArrayList<CompositeFragment>(3);
        this.shouldValidate = shouldValidate;
    }

    public boolean shouldValidate() {
        return this.shouldValidate;
    }

    @Override
    public void setDescription(String desc) {
        super.setMessage(desc);
    }

    public PHPexeItem[] getExistingItems() {
        return this.existingItems;
    }

    public void setPHPExeItem(PHPexeItem phpExeItem) {
        this.phpExeItem = phpExeItem;
    }

    public PHPexeItem getPHPExeItem() {
        return this.phpExeItem;
    }

    @Override
    public void setImageDescriptor(ImageDescriptor image) {
        super.setTitleImage(image.createImage());
    }

    protected Control createDialogArea(Composite parent) {
        ICompositeFragmentFactory[] factories;
        CTabFolder tabs = SWTUtil.createTabFolder((Composite)parent);
        ICompositeFragmentFactory[] iCompositeFragmentFactoryArray = factories = WizardFragmentsFactoryRegistry.getFragmentsFactories(FRAGMENT_GROUP_ID);
        int n = factories.length;
        int n2 = 0;
        while (n2 < n) {
            ICompositeFragmentFactory element = iCompositeFragmentFactoryArray[n2];
            CTabItem tabItem = new CTabItem(tabs, 2048);
            CompositeFragment fragment = element.createComposite((Composite)tabs, this);
            fragment.setData(this.phpExeItem);
            if (fragment instanceof IPHPExeCompositeFragment) {
                ((IPHPExeCompositeFragment)((Object)fragment)).setExistingItems(this.existingItems);
            }
            tabItem.setText(fragment.getDisplayName());
            tabItem.setControl((Control)fragment);
            this.runtimeComposites.add(fragment);
            ++n2;
        }
        this.getShell().setText("Edit PHP Executable");
        tabs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CTabItem item = (CTabItem)e.item;
                CompositeFragment fragment = (CompositeFragment)item.getControl();
                PHPExeEditDialog.this.setTitle(fragment.getTitle());
                if (PHPExeEditDialog.this.isComplete()) {
                    PHPExeEditDialog.this.setDescription(fragment.getDescription());
                }
            }
        });
        return tabs;
    }

    protected void cancelPressed() {
        Iterator<CompositeFragment> composites = this.runtimeComposites.iterator();
        while (composites.hasNext()) {
            composites.next().performCancel();
        }
        super.cancelPressed();
    }

    protected void okPressed() {
        Iterator<CompositeFragment> composites = this.runtimeComposites.iterator();
        while (composites.hasNext()) {
            composites.next().performOk();
        }
        super.okPressed();
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        this.update();
        return buttonBar;
    }

    protected boolean isComplete() {
        Iterator<CompositeFragment> composites = this.runtimeComposites.iterator();
        while (composites.hasNext()) {
            if (composites.next().isComplete()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void update() {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(this.isComplete());
        }
    }

    @Override
    public void setMessage(String newMessage, int newType) {
        if (newType == 2) {
            newType = 1;
        }
        super.setMessage(newMessage, newType);
    }
}

